/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.spi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jdo.JDOFatalInternalException;

public class I18NHelper {
    static Hashtable bundles = new Hashtable();
    static Hashtable helpers = new Hashtable();
    static Locale locale = Locale.getDefault();
    final String bundleName;
    ResourceBundle bundle = null;
    Throwable failure = null;
    static final String bundleSuffix = ".Bundle";

    I18NHelper() {
        this.bundleName = null;
    }

    I18NHelper(String string, ClassLoader classLoader) {
        this.bundleName = string;
        try {
            this.bundle = I18NHelper.loadBundle(string, classLoader);
        }
        catch (Throwable throwable) {
            this.failure = throwable;
        }
    }

    public static I18NHelper getInstance(String string) {
        return I18NHelper.getInstance(string, I18NHelper.class.getClassLoader());
    }

    public static I18NHelper getInstance(final Class clazz) {
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
        String string = I18NHelper.getPackageName(clazz.getName()) + bundleSuffix;
        return I18NHelper.getInstance(string, classLoader);
    }

    public static I18NHelper getInstance(String string, ClassLoader classLoader) {
        I18NHelper i18NHelper = (I18NHelper)helpers.get(string);
        if (i18NHelper != null) {
            return i18NHelper;
        }
        i18NHelper = new I18NHelper(string, classLoader);
        helpers.put(string, i18NHelper);
        return (I18NHelper)helpers.get(string);
    }

    public String msg(String string) {
        this.assertBundle(string);
        return I18NHelper.getMessage(this.bundle, string);
    }

    public String msg(String string, Object object) {
        this.assertBundle(string);
        return I18NHelper.getMessage(this.bundle, string, object);
    }

    public String msg(String string, Object object, Object object2) {
        this.assertBundle(string);
        return I18NHelper.getMessage(this.bundle, string, object, object2);
    }

    public String msg(String string, Object object, Object object2, Object object3) {
        this.assertBundle(string);
        return I18NHelper.getMessage(this.bundle, string, object, object2, object3);
    }

    public String msg(String string, Object[] objectArray) {
        this.assertBundle(string);
        return I18NHelper.getMessage(this.bundle, string, objectArray);
    }

    public String msg(String string, int n2) {
        this.assertBundle(string);
        return I18NHelper.getMessage(this.bundle, string, n2);
    }

    public String msg(String string, boolean bl) {
        this.assertBundle(string);
        return I18NHelper.getMessage(this.bundle, string, bl);
    }

    public ResourceBundle getResourceBundle() {
        this.assertBundle();
        return this.bundle;
    }

    static final ResourceBundle loadBundle(String string, ClassLoader classLoader) {
        ResourceBundle resourceBundle = (ResourceBundle)bundles.get(string);
        if (resourceBundle == null) {
            resourceBundle = classLoader != null ? ResourceBundle.getBundle(string, locale, classLoader) : ResourceBundle.getBundle(string, locale, I18NHelper.getSystemClassLoaderPrivileged());
            bundles.put(string, resourceBundle);
        }
        return resourceBundle;
    }

    void assertBundle() {
        if (this.failure != null) {
            throw new JDOFatalInternalException("No resources could be found for bundle:\"" + this.bundle + "\" ", this.failure);
        }
    }

    void assertBundle(String string) {
        if (this.failure != null) {
            throw new JDOFatalInternalException("No resources could be found to annotate error message key:\"" + string + "\"", this.failure);
        }
    }

    static final String getMessage(ResourceBundle resourceBundle, String string) {
        return resourceBundle.getString(string);
    }

    static final String getMessage(ResourceBundle resourceBundle, String string, Object[] objectArray) {
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] != null) continue;
            objectArray[i2] = "";
        }
        MessageFormat messageFormat = new MessageFormat(resourceBundle.getString(string));
        return messageFormat.format(objectArray);
    }

    static final String getMessage(ResourceBundle resourceBundle, String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    static final String getMessage(ResourceBundle resourceBundle, String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    static final String getMessage(ResourceBundle resourceBundle, String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    static final String getMessage(ResourceBundle resourceBundle, String string, int n2) {
        Object[] objectArray = new Object[]{new Integer(n2)};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    static final String getMessage(ResourceBundle resourceBundle, String string, boolean bl) {
        Object[] objectArray = new Object[]{String.valueOf(bl)};
        return I18NHelper.getMessage(resourceBundle, string, objectArray);
    }

    static final String getPackageName(String string) {
        int n2 = string.lastIndexOf(46);
        return n2 != -1 ? string.substring(0, n2) : "";
    }

    static ClassLoader getSystemClassLoaderPrivileged() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }
}

