/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo.identity;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.spi.I18NHelper;

public class CharIdentity
extends SingleFieldIdentity {
    static I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");
    char key;

    void construct(char c2) {
        this.key = c2;
        this.hashCode = this.hashClassName() ^ c2;
    }

    public CharIdentity(Class clazz, char c2) {
        super(clazz);
        this.construct(c2);
    }

    public CharIdentity(Class clazz, Character c2) {
        super(clazz);
        this.setKeyAsObject(c2);
        this.construct(c2.charValue());
    }

    public CharIdentity(Class clazz, String string) {
        super(clazz);
        this.assertKeyNotNull(string);
        if (string.length() != 1) {
            throw new IllegalArgumentException(msg.msg("EXC_StringWrongLength"));
        }
        this.construct(string.charAt(0));
    }

    public CharIdentity() {
    }

    public char getKey() {
        return this.key;
    }

    public String toString() {
        return String.valueOf(this.key);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CharIdentity charIdentity = (CharIdentity)object;
        return this.key == charIdentity.key;
    }

    public int compareTo(Object object) {
        if (object instanceof CharIdentity) {
            CharIdentity charIdentity = (CharIdentity)object;
            int n2 = super.compare(charIdentity);
            if (n2 == 0) {
                return this.key - charIdentity.key;
            }
            return n2;
        }
        if (object == null) {
            throw new ClassCastException("object is null");
        }
        throw new ClassCastException(this.getClass().getName() + " != " + object.getClass().getName());
    }

    @Override
    protected Object createKeyAsObject() {
        return new Character(this.key);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeChar(this.key);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.key = objectInput.readChar();
    }

    void computeHashCode() {
        this.hashCode = this.hashClassName() ^ this.key;
    }
}

