package certificatAutosignat;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.*;
import java.security.spec.*;
//import java.security.KeyFactory;
//import java.security.KeyPair;
//import java.security.NoSuchAlgorithmException;
//import java.security.PublicKey;
//import java.security.spec.InvalidKeySpecException;
//import java.security.spec.X509EncodedKeySpec;

public class P2_CertificatAutosignat {

	public static void main(String[] args) {

		// Carreguem la nostra classe amb els metodes de criptografia
		Crypto myCrypto = new Crypto();
		
		// Generem el parell de claus asimetriques
		KeyPair RSAKeys = myCrypto.randomGenerate(2048);
		
		try {

			ByteArrayOutputStream certificat = new ByteArrayOutputStream( );
			// Guardem la clau privada 
			certificat.write(RSAKeys.getPublic().getEncoded());
			
			//Guardem les dades del certificat 
			certificat.write("\r\nSujeto:\r\n".getBytes());
			certificat.write("\tCN = Angel Sanchez\r\n".getBytes());
			certificat.write("\tOU = Cicles - DAM\r\n".getBytes());
			certificat.write("\tO = Institut l'Estatut\r\n".getBytes());
			certificat.write("\tL = Rubi\r\n".getBytes());
			certificat.write("\tS = Barcelona\r\n".getBytes());
			certificat.write("\tC = es\r\n".getBytes());
			certificat.write("Emisor:\r\n".getBytes());
			certificat.write("\tCN = Angel Sanchez\r\n".getBytes());
			certificat.write("\tOU = Cicles - DAM\r\n".getBytes());
			certificat.write("\tO = Institut l'Estatut\r\n".getBytes());
			certificat.write("\tL = Rubi\r\n".getBytes());
			certificat.write("\tS = Barcelona\r\n".getBytes());
			certificat.write("\tC = es\r\n".getBytes());
			certificat.write("Valido desde divendres, 19 de febrer de 2021 16:22:23\r\n".getBytes());
			certificat.write("Valido desde divendres, 19 de febrer de 2022 16:22:23\r\n".getBytes());

			// Signem la informació del certificat (Clau privada + dades)
			byte[] signatura = myCrypto.signData(certificat.toByteArray(), RSAKeys.getPrivate());
			
			// Afegim la signatura
			certificat.write(signatura);
			
			// Desem en un fitxer el certificat
			FileOutputStream file = new FileOutputStream("M9_P2_solucio.CER");
			file.write(certificat.toByteArray());
			file.close();
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
