package crypto;

import java.util.Scanner;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.*;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;

public class P1_Xifrat_embolcallat {
	public static void main(String[] args){

/***********************************************************************************
*                                   PUNT 1 		
**********************************************************************************/
		// Demanem la contrasenya
		Scanner input = new Scanner(System.in);
		System.out.println("Contrasenya? ");
		String contrasenya = input.nextLine();
		
		// Generem la clau simetrica fent servir la contrasenya 
		Crypto myCrypto = new Crypto();
		SecretKey clauSecreta = myCrypto.passwordKeyGeneration(contrasenya, 128);
		
		// Agafem l'arxiu que volem xifrar del disc, el llegim i el guardem en una ristra de bytes
		byte[] fileData = null;
		String abb;
		try {
			fileData = Files.readAllBytes(Paths.get("Text en clar.txt"));
			
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		// Xifrem les dades 
		byte[] dadesXifrades = myCrypto.encryptData(clauSecreta, fileData);
		
		// Guardem les dades xifrades al fitxer "Text xifrat.bin"
		try {
			Files.write(Paths.get("Text xifrat.bin"), dadesXifrades);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
/***********************************************************************************
 *                                   PUNT 2 		
 **********************************************************************************/
		
		// Generem el parell de claus simetriques publica/privada
		KeyPair parellClaus = myCrypto.randomGenerate(2048);
		
		// Obtenim la clau privada i la desem al fitxer "clau_privada.bin"
		PrivateKey clauPrivada = parellClaus.getPrivate();
		byte[] key = clauPrivada.getEncoded();
		FileOutputStream keyfos;
		try {
			keyfos = new FileOutputStream("clau_privada.bin");
			keyfos.write(key);
			keyfos.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		// Obtenim la clau publica i xifrem la clau simetrica del punt anterior
		PublicKey clauPublica = parellClaus.getPublic();
		byte[] clauSecretaXifrada = myCrypto.encryptData(clauSecreta.getEncoded(), clauPublica);
		
		// Desem la clau secreta simetrica xifrada al fitxer "clau_xifrada.bin"
		try {
			keyfos = new FileOutputStream("clau_xifrada.bin");
			keyfos.write(clauSecretaXifrada);
			keyfos.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
/******************************************************************************************************************************************
* PUNT 2 amb el metode d'enbolcallar de la classe Crypto modificat per fer servir la clau simetrica que surt de la paraula clau introduida 		
*******************************************************************************************************************************************/
		
		// A Crypto.java modifiquen el metode encryptWrappedData
		
		byte[][] ecryptedData_encrKey = myCrypto.encryptWrappedDataExternalKey(fileData, clauSecreta, clauPublica );	
		
		//Obtenim les dades xifrades i les guardem al fitxer "Text xifrat2.bin"
		dadesXifrades = ecryptedData_encrKey[0];
		try {
			Files.write(Paths.get("Text xifrat2.bin"), dadesXifrades);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// obtenim la clau secreta simetrica xifrada i la desem al fitxer "clau_xifrada2.bin"
		clauSecretaXifrada = ecryptedData_encrKey[1];
		try {
			keyfos = new FileOutputStream("clau_xifrada2.bin");
			keyfos.write(clauSecretaXifrada);
			keyfos.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
